# Set up the variables.
JENKINS_SERVER_URL=$1
JENKINS_AGENT_NUMBER=$2
JENKINS_AGENT_SECRET=$3
LINODE_S3_ACCESS_KEY=$4
LINODE_S3_SECRET_KEY=$5
LINODE_S3_REGION=$6

# Update the system.
apt-get update -qq

# Configure the firewall.
apt-get install -yq ufw
ufw allow 22/tcp
ufw --force enable
ufw reload

# Harden SSH security.
sed -i -e '/PasswordAuthentication/d' /etc/ssh/sshd_config
echo "PasswordAuthentication no" >> /etc/ssh/sshd_config

# Install Node.
curl -o- https://raw.githubusercontent.com/nvm-sh/nvm/v0.39.1/install.sh | bash
. ~/.nvm/nvm.sh
nvm install node
ln -s "$NVM_DIR/versions/node/$(nvm version)/bin/node" "/usr/local/bin/node"
ln -s "$NVM_DIR/versions/node/$(nvm version)/bin/npm" "/usr/local/bin/npm"
ln -s "$NVM_DIR/versions/node/$(nvm version)/bin/npx" "/usr/local/bin/npx"

# Install Docker.
apt-get install -yq ca-certificates curl gnupg
mkdir -m 0755 -p /etc/apt/keyrings
curl -fsSL https://download.docker.com/linux/ubuntu/gpg | sudo gpg --dearmor -o /etc/apt/keyrings/docker.gpg
echo "deb [arch="$(dpkg --print-architecture)" signed-by=/etc/apt/keyrings/docker.gpg] https://download.docker.com/linux/ubuntu "$(. /etc/os-release && echo "$VERSION_CODENAME")" stable" | sudo tee /etc/apt/sources.list.d/docker.list > /dev/null
apt-get update -qq
apt-get install -yq docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin

# Install kubectl.
curl -LO https://storage.googleapis.com/kubernetes-release/release/$(curl -s https://storage.googleapis.com/kubernetes-release/release/stable.txt)/bin/linux/amd64/kubectl
chmod +x ./kubectl
mv ./kubectl /usr/local/bin/kubectl

# Install and configure rclone.
curl https://rclone.org/install.sh | sudo bash
mkdir /opt/rclone
cat > /opt/rclone/rclone.conf <<EOF
[linodes3]
type = s3
provider = Other
env_auth = false
acl = private
access_key_id = $LINODE_S3_ACCESS_KEY
secret_access_key = $LINODE_S3_SECRET_KEY
endpoint = $LINODE_S3_REGION.linodeobjects.com
EOF

# Install Java.
apt-get install -yq default-jre

# Set up the Jenkins user and home directory.
useradd --groups docker --home /home/jenkins --shell /bin/bash jenkins
mkdir -p /home/jenkins/
chown -R jenkins:jenkins /home/jenkins
chmod -R 777 /home/jenkins

# Create a directory for the Jenkins agent and a script to run it.
mkdir -p /usr/local/jenkins-service/
chown jenkins /usr/local/jenkins-service

cat > /usr/local/jenkins-service/jenkins-agent-start.sh <<EOF
#!/bin/bash
cd /usr/local/jenkins-service
curl -sO ${JENKINS_SERVER_URL}/jnlpJars/agent.jar
java -jar agent.jar -jnlpUrl ${JENKINS_SERVER_URL}/manage/computer/docker%2Dnode%2Dagent%2D${JENKINS_AGENT_NUMBER}/jenkins-agent.jnlp -secret ${JENKINS_AGENT_SECRET}  -workDir "/home/jenkins"
exit 0

EOF
chmod +x /usr/local/jenkins-service/jenkins-agent-start.sh

# Create a service to run the Jenkins agent script.
cat > /etc/systemd/system/jenkins-agent.service <<EOF
[Unit]
Description=Jenkins Agent

[Service]
User=jenkins
WorkingDirectory=/home/jenkins
ExecStart=/bin/bash /usr/local/jenkins-service/jenkins-agent-start.sh
Restart=always

[Install]
WantedBy=multi-user.target

EOF
systemctl start jenkins-agent
systemctl enable jenkins-agent

